﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja INF-2</title>
		<script runat="server">

	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			miesiąc = PrevMonth();
		}
		
		YearMonth miesiąc;
		[Required]
		[Caption("Deklaracja za")]
		public YearMonth Miesiąc {
			get { return miesiąc; }
			set {
				if (miesiąc==YearMonth.Empty)
					value = PrevMonth(); 
				miesiąc = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		YearMonth PrevMonth() {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data==Date.Empty)
				data = Date.Today;
			return new YearMonth(data)-1;
		}
	}
	
	PrnParams pars = null; 
	[Context] 
	public PrnParams Params { 
		set { pars = value; } 
	}

    Dictionary<OddzialFirmy, List<Pracownik>> dict = new Dictionary<OddzialFirmy, List<Pracownik>>();
    List<OddzialFirmy> oddzialy = new List<OddzialFirmy>();
    string title;

	void OnContextLoad(Object sender, EventArgs args) {
		ReportHeader1["MIESIĄC"] = pars.Miesiąc.ToString();
        title = ReportHeader1.Title;
		
		KadryModule kadry = KadryModule.GetInstance(dc);
		Soneta.Business.View view = kadry.Pracownicy.GetNaEtatach(pars.Miesiąc.ToFromTo());

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.Miesiąc.FirstDay;
            foreach (Pracownik pracownik in view) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(new OddzialFirmy(RowCreator.Empty), list = new List<Pracownik>());
            foreach (Pracownik pracownik in view)
                list.Add(pracownik);
        }

        ZPCHR zpchr = new ZPCHR(false, pars.Miesiąc, ZPCHR.WarunkiNaliczania.PFRON);
        ArrayList lista = new ArrayList();
        oddzialy.AddRange(dict.Keys);
        foreach (OddzialFirmy of in oddzialy)
            lista.Add(zpchr.Razem(dict[of], 2));
        DataRepeater1.DataSource = lista;
	}
	
	void OnBeforeRow(Object sender, EventArgs args) {
        OddzialFirmy of = oddzialy[0];
        oddzialy.Remove(of);
        ReportHeader1.Title = !string.IsNullOrEmpty(of.Symbol) ? title.Replace("%ODDZIAL%", "Oddział: " + of) : title.Replace("%ODDZIAL%", "");

		ZPCHR.MiesiącInfo info = (ZPCHR.MiesiącInfo)DataRepeater1.CurrentRow;
		//0.06 * p13 - (3 * p15 + 2 * p17 + p14)
        decimal v = 0.06m * info.Etaty - 3 * info.EtatyZnacznySchorzenia - 2 * info.EtatyUmiarkowanySchorzenia -
            (info.EtatyNiepełnosprawni + info.EtatyNiepełnosprawniDo16roku + info.EtatyNiepełnosprawniBezSTN);
		if (v<0)
			v = 0;
		DataLabel8.EditValue = Soneta.Tools.Math.Round(v, 4).ToString("0.0000");
        EtatyNiepełnosprawni.EditValue = info.EtatyNiepełnosprawni + info.EtatyNiepełnosprawniDo16roku + info.EtatyNiepełnosprawniBezSTN;
        Niepełnosprawni.EditValue = info.Niepełnosprawni + info.NiepełnosprawniDo16roku + info.NiepełnosprawniBezSTN;
        EtatyBrak.EditValue = info.EtatyNiepełnosprawniDo16roku + info.EtatyNiepełnosprawniBezSTN;
        Brak.EditValue = info.NiepełnosprawniDo16roku + info.NiepełnosprawniBezSTN;
	}
	
	static void Msg(object obj) {
	}
	
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaMiesięcznaINF2" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" RowTypeName="Soneta.Kadry.ZPCHR+MiesiącInfo,Soneta.KadryPlace"
				onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
				<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="INFORMACJA DLA DEKLARACJI DEK-I-0|Deklaracja miesięcznych wpłat na PFRON|</strong>Okres sprawozdawczy: <strong>%MIESIĄC%|%ODDZIAL%"
					runat="server"></cc1:reportheader>
				<DIV style="FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; BORDER-BOTTOM: thin solid; FONT-FAMILY: Verdana">C. 
					Dane o zatrudnieniu</DIV>
				<P>
					<TABLE id="Table3" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center" width="5%">E</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center" width="20%">Zatrudnienie ogółem</TD>
							<TD align="left" width="20%">
								<TABLE id="Table6" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">16.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel1" runat="server" Format="{0:n}" DataMember="Etaty"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD align="center" width="35%">w tym osób niepełnosprawnych ogółem</TD>
							<TD align="right">
								<TABLE id="Table7" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">17.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" id="EtatyNiepełnosprawni"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center" width="5%">O</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center" width="20%">Zatrudnienie ogółem</TD>
							<TD width="20%">
								<TABLE id="Table15" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">18.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel10" runat="server" Format="{0:n}" DataMember="Pracownicy"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD align="center" width="35%">w tym osób niepełnosprawnych ogółem</TD>
							<TD>
								<TABLE id="Table14" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">19.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" id="Niepełnosprawni"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
				</P>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">w tym osób niepełnosprawnych 
					w stopniu:<BR>
					<TABLE id="Table4" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD width="5%">&nbsp;</TD>
							<TD width="30%" colSpan="2">
								<P align="center">znacznym</P>
							</TD>
							<TD width="30%" colSpan="2">
								<P align="center">umiarkowanym</P>
							</TD>
							<TD width="20%">
								<P align="center">lekkim</P>
							</TD>
							<TD width="15%">
								<P align="center">bez ustalonego stopnia niepełnosprawności</P>
							</TD>
						</TR>
						<TR>
							<TD width="5%">&nbsp;</TD>
							<TD width="15%">
								<P align="center">ze szczególnymi<BR>
									schorzeniami</P>
							</TD>
							<TD>
								<P align="center">pozostali</P>
							</TD>
							<TD width="15%">
								<P align="center">ze szczególnymi<BR>
									schorzeniami</P>
							</TD>
							<TD>
								<P align="center">pozostali</P>
							</TD>
							<TD>
								<P>&nbsp;</P>
							</TD>
							<TD>
								<P>&nbsp;</P>
							</TD>
						</TR>
						<TR>
							<TD width="5%" align="center">E</TD>
							<TD>
								<TABLE id="Table8" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">20.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel3" runat="server" Format="{0:n}" DataMember="EtatyZnacznySchorzenia"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table9" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">21.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel4" runat="server" Format="{0:n}" DataMember="EtatyZnacznyPozostali"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table10" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">22.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel5" runat="server" Format="{0:n}" DataMember="EtatyUmiarkowanySchorzenia"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table11" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">23.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel6" runat="server" DataMember="EtatyUmiarkowanyPozostali"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table12" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">24.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel7" runat="server" Format="{0:n}" DataMember="EtatyLekki"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">25.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" id="EtatyBrak"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
						<TR>
							<TD width="5%" align="center">O</TD>
							<TD>
								<TABLE id="Table16" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">26.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel15" runat="server" Format="{0:n}" DataMember="ZnacznySchorzenia"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table17" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">27.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel14" runat="server" Format="{0:n}" DataMember="ZnacznyPozostali"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table18" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">28.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel13" runat="server" Format="{0:n}" DataMember="UmiarkowanySchorzenia"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table19" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">29.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel12" runat="server" DataMember="UmiarkowanyPozostali"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table20" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">30.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel11" runat="server" Format="{0:n}" DataMember="Lekki"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table5" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">31.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" id="Brak"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
				</P>
				<P>
					<TABLE id="Table2" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD align="center" width="80%">Liczba pracowników odpowiadająca różnicy między 
								zatrudnieniem<BR>
								zapewniającym osiągnięcie wymaganego wskaźnika zatrudnienia osób 
								niepełnosprawnych<BR>
								a rzeczywistym zatrudnieniem osób niepełnosprawnych</TD>
							<TD>
								<P>&nbsp;
									<TABLE id="Table13" cellSpacing="0" cellPadding="0" width="100%" border="0">
										<TR>
											<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">32.</TD>
											<TD align="right">
												<ea:DataLabel id="DataLabel8" runat="server"></ea:DataLabel></TD>
										</TR>
									</TABLE>
								</P>
							</TD>
						</TR>
					</TABLE>
				</P>
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
